<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">


<style>
    body{
        font-family: 'Segoe UI', Tahoma, sans-serif;
        background:#0f2d24;
        margin:0;
        padding:15px;
    }

    .invoice-box{
        max-width:850px;
        margin:auto;
        background:#ffffff;
        padding:20px;
        border-radius:10px;
    }

    /* HEADER */
    .header{
        display:flex;
        justify-content:space-between;
        align-items:center;
        border-bottom:3px solid #1b5e20;
        padding-bottom:10px;
    }

   .company-info h2{
    margin:0;
    color:#1b5e20;
    font-size:26px;
    font-weight:800;
    letter-spacing:1px;
    text-transform:uppercase;
    position:relative;
    padding-bottom:4px;
}

.company-info h2::after{
    content:"";
    position:absolute;
    left:0;
    bottom:0;
    width:60px;
    height:3px;
    background:#2e7d32;
    border-radius:2px;
}

    .company-info div{
        font-size:13px;
        line-height:1.4;
    }


.invoice-title{
    display:inline-block;
    margin-top:100px;
    background:#1b5e20;
    color:#fff;
    margin-left: -200px;
    font-size:18px;
    font-weight:500;
    padding:3px 10px;
    border-radius:10px;
    letter-spacing:1px;
    box-shadow:
        0 10px 20px rgba(0,0,0,.550),
        0 4px 6px rgba(0,0,0,0.10);
}


.logo img{
     width:130px;
     height:130px;
  /*
    display:block;

    box-shadow:
        0 10px 20px rgba(0,0,0,0.15),
        0 4px 6px rgba(0,0,0,0.10);*/
}



    /* CUSTOMER INFO */
    .info{
        margin-top:15px;
        display:flex;
        justify-content:space-between;
        background:#e8f5e9;
        padding:8px 12px;
        border-radius:6px;
        font-size:18px;
    }

    /* TABLE */
    table{
        width:100%;
        border-collapse:collapse;
        margin-top:15px;
        font-size:13px;
    }

    table thead{
        background:#1b5e20;
        color:#fff;
    }

    table th{
        padding:6px;
        border:1px solid #a5d6a7;
        font-weight:600;
    }

    table td{
        padding:5px;
        border:1px solid #c8e6c9;
        text-align: center;
    }

    table tbody tr:nth-child(even){
        background:#f6fbf7;
    }

    /* TOTAL */
    .total-section{
        margin-top:15px;
        display:flex;
        justify-content:flex-end;
    }

    .total-box{
        width:280px;
        background:#1b5e20;
        color:#fff;
        padding:12px;
        border-radius:8px;
        font-size:14px;
    }

    .total-box div{
        display:flex;
        justify-content:space-between;
        margin-bottom:6px;
    }

    .total-box .grand{
        font-size:16px;
        font-weight:bold;
        border-top:1px solid #a5d6a7;
        padding-top:6px;
    }

    /* WORDS */
.words{
    margin-top:12px;
    font-size:17px;
    background:#f1f8f4;
    padding:10px 12px;
    border-right:5px solid #1b5e20;

    font-family: 'Jameel Noori Nastaleeq', serif;
    direction: rtl;
    text-align: right;
    line-height: 1.9;
}

    /* FOOTER */
    .footer{
        margin-top:25px;
        text-align:center;
        font-size:12px;
        color:#2e7d32;
        border-top:1px dashed #a5d6a7;
        padding-top:6px;
    }

    /* PRINT */
    @media print{
        body{
            background:#fff;
            padding:0;
        }
        .invoice-box{
            border-radius:0;
        }
    }


    
</style>
</head>

<body>

<div class="invoice-box">

    <!-- HEADER -->
    <div class="header">
        <div class="company-info">
            <h2>PAK TRADING COMPANY</h2>
            <div>📞 0301-7925943 , 0345-8622202</div>
            <div>📍 Feroza</div>
        </div>
        <div class="invoice-title">Sales Invoice</div>

        <div class="logo">
            <img src="logo.png">
        </div>
    </div>




<?php 
 // echo @$_GET['msg'];
 //  session_start();
	// if(isset($_SESSION['userId'])){
	// if(isset($_GET['accid'])){
		require 'connection.php';
		$vno= $_GET['vno'];
	
function dateDiffInDays($date1, $date2)  
{ 
    // Calculating the difference in timestamps 
    $diff = strtotime($date2) - strtotime($date1); 
      
    // 1 day = 24 hours 
    // 24 * 60 * 60 = 86400 seconds 
    return abs(round($diff / 86400)); 
} 


        $qry = "SELECT dated, accid from sales where saleid = '$vno'";
        $run = mysqli_query($connect, $qry);
        $row = mysqli_fetch_array($run);
        $farmid = $row['accid'];
        $date1 = $row['dated'];
      $rundate = $date1;
      $dat= date_create($rundate);
      $dated1=date_format($dat,"d-m-Y");


		$qry = "SELECT * from accreg where accid = '$farmid'";
        $run = mysqli_query($connect, $qry);
        $row = mysqli_fetch_array($run);
        $name = $row['accname'];
?>



    <!-- INFO -->
    <div class="info">
        <div><strong>Customer:</strong> <?php echo $name; ?></div>
        <div><strong>Date: </strong><?php echo $dated1; ?></div>
    </div>
<title><?php echo $name; ?></title>
    <!-- TABLE -->
    <table>
        <thead>
            <tr>
                <th width="6%">Sr</th>
                <th>Product Name</th>
                <th width="8%">Qty</th>
                <th width="12%">Rate</th>
                <th width="14%">Amount</th>
            </tr>
        </thead>
        <tbody>
            
            <?php
$totalbil = 0;
$srno = 1;
$totlqty=0;
$rowclr = 0;
$rowclrs = 0;
        require 'connection.php';

			$qry = "SELECT * from stockledger  where vno = '$vno' and invoiceno='Sales' order by trid asc";
        $run_qry = mysqli_query($connect, $qry);
        while ($row=mysqli_fetch_array($run_qry)) {
            $itemid=$row['itemid'];

        $qryitmname = "SELECT * from itemreg where itemid = '$itemid'";
        $runitmname = mysqli_query($connect, $qryitmname);
        $rowitmname = mysqli_fetch_array($runitmname);
        $itemname = $rowitmname['itemname'];

 
?>

            
            
            <tr>
                <td><?php echo $srno; ?></td>
                   <td><?php echo $itemname; ?></td>
                      <td><?php echo $row['stockout']; ?></td>
                         <td><?php echo number_format($row['rateout'],0); ?></td>
                            <td><?php     $amt=$row['stockout']*$row['rateout'];
    $totalbil=$totalbil+$amt;
echo number_format($amt,0); ?></td>
             
            </tr>
          	<?php
        $srno=$srno+1;
        	}
				?>
          
          
        </tbody>
    </table>

    <!-- TOTAL -->
    <div class="total-section">
        <div class="total-box">
            <div><span>Sub Total</span><span><?php echo number_format($totalbil,0) ?></span></div>
            <div class="grand"><span>Total</span><span><?php echo number_format($totalbil,0) ?></span></div>
        </div>
    </div>

    <!-- WORDS -->
<!--     <div class="words">
        <strong>Amount in Words:</strong> Thirty One Thousand Rupees Only.
    </div> -->

    <div class="words">
        <strong style="font-style: jameel-noori;">نوٹ:  بل میں کسی قسم کی تبدیلی / غلطی کی صورت میں 2 دن کے اندر اندر انفارم کریں ۔ بعد میں کوئی عذر قبول نہ ہوگا۔</strong>
    </div>
    <!-- FOOTER -->
    <div class="footer">
       Thanks for being our customer.
    </div>

</div>

</body>
</html>
