<?php
session_start();
if(!isset($_SESSION['userId'])) {
    
      header("Location: unauthorized.php");
    exit();
    // die('Unauthorized');
}

include 'template/header.php';  
require 'connection.php';
?>

<link rel="stylesheet" href="css/jquery-ui.css">
<link rel="stylesheet" href="bootstrap.min.css" />
<link rel="stylesheet" href="css/bootsrap_my.css" />

<script src="js/jquery-1.12.4.js"></script>
<script src="js/jquery-ui.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<div class="ch-container">
    
    <style>
/* Stylish BRV Header */
.brv-header {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    font-size: 2.5rem;
    font-weight: 700;
    background: linear-gradient(90deg, #00bfff, #1e90ff, #00ffff);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    text-align: center;
    padding: 20px 0;
    border-bottom: 3px solid #00bfff;
    text-shadow: 0 2px 4px rgba(0,0,0,0.2);
    transition: transform 0.3s ease;
}

.brv-header:hover {
    transform: scale(1.05);
}

/* Stylish Input Boxes */
.stylish-input {
   width: 100%;
    padding: 10px 15px;
    font-size: 1.5rem; /* Bada readable text */
    font-weight: 500;
    color: #222;
    border: 2px solid #ccc;
    border-radius: 6px;
    outline: none;
    transition: all 0.3s ease;
    background-color: #f9f9f9;
}

/* Hover effect */
.stylish-input:hover {
    border-color: #1e90ff;
    box-shadow: 0 0 8px rgba(30,144,255,0.3);
    background-color: #fff;
       font-size: 2.3rem; /* Bada readable text */
    font-weight: 700;
}

/* Focus effect */
.stylish-input:focus {
    border-color: #00bfff;
    box-shadow: 0 0 12px rgba(0,191,255,0.5);
    background-color: #fff;
    transform: scale(1.02);
     font-size: 2.3rem; /* Bada readable text */
    font-weight: 700;
   
}

/* Optional placeholder color */
.stylish-input::placeholder {
    color: #999;
    transition: color 0.3s ease;
}

.stylish-btn {
    display: block;
    width: 40%; /* Half se chhota */
    margin: 20px auto; /* Center horizontally */
    padding: 12px 0;
    font-size: 1.1rem;
    font-weight: bold;
    color: #fff;
    background: linear-gradient(90deg, #00bfff, #1e90ff);
    border: none;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
    text-align: center;
}

/* Hover Animation */
.stylish-btn:hover {
    background: linear-gradient(90deg, #1e90ff, #00bfff);
    transform: translateY(-3px);
    box-shadow: 0 5px 15px rgba(0,191,255,0.4);
}

/* Active / Click effect */
.stylish-btn:active {
    transform: translateY(1px) scale(0.98);
    box-shadow: 0 3px 10px rgba(0,191,255,0.3);
}
</style>


<h2 class="brv-header">Bank Payment Voucher (BPV)</h2>

    <div class="row">
        <div id="content" class="col-lg-12 col-sm-12">

            <div class="row">
                <div class="box col-md-12">
                    <div class="box-inner">
                      

                        <div class="box-content row">

                            <!-- Date -->
                            <div class="col-lg-12 col-md-12">
                                <input style="border: none; border-bottom: 1px solid black; float: right; font-size: 2rem" 
                                    type="date" id="dated">
                            </div>
<br>
<br>

                            <!-- Bank and Received From -->
                            <div style="margin-bottom: 20px;" class="col-lg-12 col-md-12">
                                <div class="col-lg-5 col-md-12">
                                    <label>Select Bank</label>
                                    <select id="bankid" class="form-control selectpicker" data-live-search="true">
                                        <?php
                                        $qry = "SELECT * FROM accreg";
                                        $run = mysqli_query($connect, $qry) or die(mysqli_error($connect));
                                        while($row = mysqli_fetch_array($run)){
                                        ?>
                                        <option value="<?php echo $row['accid']; ?>"><?php echo $row['accname']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>

                                <div class="col-lg-5 col-md-12">
                                    <label>Paid To</label>
                                    <select id="accid" class="form-control selectpicker" data-live-search="true">
                                        <?php
                                        $qry = "SELECT * FROM accreg";
                                        $run = mysqli_query($connect, $qry) or die(mysqli_error($connect));
                                        while($row = mysqli_fetch_array($run)){
                                        ?>
                                        <option value="<?php echo $row['accid']; ?>"><?php echo $row['accname']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                            <!-- Payment Method, Cheque/Ref, Description, Amount -->
                            <div class="col-lg-12 col-md-12">
                                <div style='margin-bottom: 50px;' class="col-lg-3 col-md-12">
                                    <label>Payment Method</label>
                                    <select id="paymentmethod" class="form-control selectpicker" data-live-search="true">
                                        <option value="">-- Select Payment Method --</option>
                                        <option value="Cash Withdraw">Cash Withdraw</option>
                                        <option value="Cheque Clear">Cheque Clear</option>
                                        <option value="Online Transfer">Online Transfer</option>
                                        <option value="Pay Order">Pay Order</option>
                                        <option value="RTGS">RTGS</option>
                                        <option value="Salary Transfer">Salary Transfer</option>
                                        <option value="Bank Charges">Bank Charges</option>
                                    </select>
                                </div>

                                <div style='margin-bottom: 50px;' class="col-lg-2 col-md-12">
                                    <label>Cheque / Ref No.</label>
                                    <input type="text" id="refno" class="stylish-input">
                                </div>

                                <div style='margin-bottom: 50px;' class="col-lg-3 col-md-12">
                                    <label>Description</label>
                                    <input type="text" id="description" class="stylish-input">
                                </div>

                                <div style='margin-bottom: 50px;' class="col-lg-2 col-md-12">
                                    <label>Amount (Rs.)</label>
                                    <input type="text" id="amount" class="stylish-input">
                                </div>

                                <div hidden class="col-lg-2 col-md-12">
                                    <input type="text" id="remarks" class="stylish-input">
                                </div>
                            </div>

                            <!-- Save Button -->
                            <div class="col-lg-12" style="margin-top:20px;">
                               <button class="stylish-btn" id="saveBPV">Save Record</button>
                            </div>

                        

                        </div> <!-- box-content row -->
                    </div> <!-- box-inner -->
                </div> <!-- box -->
            </div> <!-- row -->

        </div> <!-- content -->
    </div> <!-- row -->
</div> <!-- ch-container -->

<div class="col-lg-12" style="margin-top:30px;">
    <h4>Today's BPV Vouchers
      <select id="filterPaymentMode" class="form-control" style="width:200px; display:inline-block;">
                               
                                        <option value="">-- All --</option>
                                        <option value="Cash Withdraw">Cash Withdraw</option>
                                        <option value="Cheque Clear">Cheque Clear</option>
                                        <option value="Online Transfer">Online Transfer</option>
                                        <option value="Pay Order">Pay Order</option>
                                        <option value="RTGS">RTGS</option>
                                        <option value="Salary Transfer">Salary Transfer</option>
                                        <option value="Bank Charges">Bank Charges</option>
                                    </select>
    </h4>
    <table class="table table-bordered glow-table">
       
        <tbody id="bpvBody">
            <!-- Data will appear here -->
        </tbody>
    </table>
</div>

<?php
include 'template/footer.php';
?>

<script type="text/javascript">
var today = new Date();
document.getElementById("dated").value = today.getFullYear() + '-' + ('0' + (today.getMonth() + 1)).slice(-2) + '-' + ('0' + today.getDate()).slice(-2);
</script>

<script>
$(document).ready(function() {

    function loadBPV(date, paymentMode = '') {
        $.ajax({
            url: 'load_today_bpv.php',
            type: 'POST',
            data: { dated: date, payment_mode: paymentMode },
            success: function(response) {
                $('#bpvBody').html(response);
            },
            error: function() {
                Swal.fire('Error', 'Unable to fetch vouchers', 'error');
            }
        });
    }

    let today = $('#dated').val();
    loadBPV(today);

    // Date change -> reload list
    $('#dated').on('change', function() {
        loadBPV($(this).val(), $('#filterPaymentMode').val());
    });

    // Payment Mode filter -> reload list
    $('#filterPaymentMode').on('change', function() {
        loadBPV($('#dated').val(), $(this).val());
    });

    // Save BRV
    $('#saveBPV').click(function(e){
        e.preventDefault();

        var formData = {
            dated: $('#dated').val(),
            bankid: $('#bankid').val(),
            accid: $('#accid').val(),
            payment_mode: $('#paymentmethod').val(),
            description: $('#description').val(),
            amount: $('#amount').val(),
            cheque_or_refno: $('#refno').val(),
            userid: <?= $_SESSION['userId']; ?>,
            remarks: $('#remarks').val()
        };

        $.ajax({
            url: 'save_bpv.php',
            type: 'POST',
            data: formData,
            success: function(response){
                Swal.fire({
                    title: 'BPV Response',
                    html: response,
                    icon: response.toLowerCase().includes('success') ? 'success' : 'error',
                    confirmButtonText: 'OK'
                });

                if(response.toLowerCase().includes('success')){
                    $('#description, #amount, #refno, #remarks').val('');
                    loadBPV($('#dated').val(), $('#filterPaymentMode').val());
                }
            },
            error: function(xhr, status, error){
                Swal.fire('Error', error, 'error');
            }
        });
    });

});
</script>
