<?php
require 'connection.php';
mysqli_set_charset($connect, "utf8mb4");

// GET DATE RANGE
$from = $_GET['from'] ?? date('Y-m-01');
$to   = $_GET['to'] ?? date('Y-m-d');

// MAIN QUERY: Chart → Group → Accounts
$q = "
SELECT 
    ch.ChartName,
    grp.groupname,
    X.accid,
    X.accname,
    X.total_received,
    X.total_paid
FROM (
    SELECT 
        L.accid,
        A.accname,
        A.groupid,
        SUM(L.credit) AS total_received,
        SUM(L.debit)  AS total_paid
    FROM ledger L
    JOIN accreg A ON A.accid = L.accid
    WHERE 
        
         L.dated BETWEEN '$from' AND '$to'
        AND L.accid <> 3
    GROUP BY L.accid, A.accname, A.groupid
) AS X
JOIN groupreg grp ON grp.groupid = X.groupid
JOIN chartacc ch ON ch.chartid = grp.chartid
ORDER BY
    ch.chartid,         -- Chart order
    grp.groupname,      -- Group order
    CASE WHEN X.total_received > 0 THEN 1 ELSE 2 END,  -- Cash Received first
    X.accname
";

$result = mysqli_query($connect, $q);

// VARIABLES FOR TOTALS
$current_chart = "";
$current_group = "";
$group_in = $group_out = 0;
$overall_in = $overall_out = 0;
?>

<h2 style="text-align:center;">Cash Flow Report (Date Range)</h2>

<!-- DATE RANGE FORM -->
<form method="GET" style="text-align:center; margin-bottom:10px;">
    <label>From: </label>
    <input type="date" name="from" value="<?= $from ?>" required>
    &nbsp;&nbsp;
    <label>To: </label>
    <input type="date" name="to" value="<?= $to ?>" required>
    &nbsp;&nbsp;
    <button type="submit">Search</button>
</form>

<table border="1" width="100%" cellpadding="6" style="border-collapse: collapse; font-family:Verdana; font-size:14px;">

<?php while($row = mysqli_fetch_assoc($result)):

    // CHART HEADER
    if ($current_chart != $row['ChartName']) {

        // Print previous group total before new chart
        if ($current_group != "") {
            echo "
            <tr style='font-weight:bold; background:#e0f7fa;'>
                <td colspan='2' align='right'>Group Total ($current_group)</td>
                <td>".number_format($group_out,2)."</td>
                <td>".number_format($group_in,2)."</td>
                <td>".number_format($group_in - $group_out,2)."</td>
            </tr>";
            $group_in = $group_out = 0;
        }

        // Add 2 empty rows to separate charts (without border)
        if ($current_chart != "") {
            echo "<tr style='border:none;'><td colspan='5' style='border:none;'>&nbsp;</td></tr>";
            echo "<tr style='border:none;'><td colspan='5' style='border:none;'>&nbsp;</td></tr>";
        }

        // Chart header
        echo "
        <tr style='background:#333; color:white; font-size:16px;'>
            <td colspan='5'><b>{$row['ChartName']}</b></td>
        </tr>";

        $current_chart = $row['ChartName'];
        $current_group = ""; // reset group for new chart
    }

    // GROUP HEADER
    if ($current_group != $row['groupname']) {

        // Print previous group total
        if ($current_group != "") {
            echo "
            <tr style='font-weight:bold; background:#e0f7fa;'>
                <td colspan='2' align='right'>Group Total ($current_group)</td>
                <td>".number_format($group_out,2)."</td>
                <td>".number_format($group_in,2)."</td>
                <td>".number_format($group_in - $group_out,2)."</td>
            </tr>";
        }

        // Group header
        echo "
        <tr style='background:#444; color:white;'>
            <td colspan='5'><b>{$row['groupname']}</b></td>
        </tr>

        <tr style='background:#ddd;'>
            <th>Acc ID</th>
            <th>Account Name</th>
            <th>Debit (Cash Paid)</th>
            <th>Credit (Cash Received)</th>
            <th>Net Cash (Received – Paid)</th>
        </tr>";

        $current_group = $row['groupname'];
        $group_in = $group_out = 0;
    }

    // Row totals
    $debit  = $row['total_paid'];      // Cash Paid
    $credit = $row['total_received'];  // Cash Received
    $net    = $credit - $debit;        // Net Cash = Received – Paid

    // Group & overall totals
    $group_in  += $credit;
    $group_out += $debit;
    $overall_in  += $credit;
    $overall_out += $debit;

?>

<tr>
    <td><?= $row['accid'] ?></td>
    <td><?= $row['accname'] ?></td>
    <td><?= number_format($debit,2) ?></td>
    <td><?= number_format($credit,2) ?></td>
    <td><?= number_format($net,2) ?></td>
</tr>

<?php endwhile; ?>

<!-- LAST GROUP TOTAL -->
<?php if ($current_group != ""): ?>
<tr style='font-weight:bold; background:#e0f7fa;'>
    <td colspan='2' align='right'>Group Total (<?= $current_group ?>)</td>
    <td><?= number_format($group_out,2) ?></td>
    <td><?= number_format($group_in,2) ?></td>
    <td><?= number_format($group_in - $group_out,2) ?></td>
</tr>
<?php endif; ?>

<!-- OVERALL TOTAL -->
<tr style="font-weight:bold; background:#f0f0f0;">
    <td colspan="2" align="right">OVERALL TOTAL</td>
    <td><?= number_format($overall_out,2) ?></td>
    <td><?= number_format($overall_in,2) ?></td>
    <td><?= number_format($overall_in - $overall_out,2) ?></td>
</tr>

</table>
