<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Balance Sheet</title>

<link href="css/bootstrap-cerulean.min.css" rel="stylesheet">

<style>
body{
    background:#f4f6f9;
    font-family:"Segoe UI",Arial,sans-serif;
}

/* PAGE */
.container{
    background:#fff;
    padding:30px;
    margin-top:20px;
    border-radius:10px;
}

h3{
    font-weight: bolder;
    color: black;
}


/* TITLE */
.balance-title{
    text-align:center;
    font-weight:900;
    letter-spacing:2px;
}
h2.balance-title{font-size:36px;margin-bottom:0;}
h4.balance-title{font-size:18px;color:#555;}

/* TABLE */
table{
    width:100%;
    border-collapse:collapse;
    font-size:20px;
}
td{
    border:1px solid #ccc;
    padding:12px;
}

/* AMOUNT */
.amount{
    text-align:right;
    font-weight:900;
    font-size:22px;
}

/* SECTIONS (INLINE SAFE COLORS) */
.assets-head td{
    background:#c8f7dc !important;
    color:#0b6b3a !important;
    font-weight:900;
}
.asset td{
    background:#eafff3 !important;
    
}

.total-assets td{
    background:#9be7c4 !important;
    font-size:24px;
    font-weight:900;
}

/* LIABILITIES */
.liability-head td{
    background:#ffd6d6 !important;
    color:#9b1c1c !important;
    font-weight:900;
}
.liability td{
    background:#fff0f0 !important;
}

/* CAPITAL */
.capital-head td{
    background:#dbe8ff !important;
    color:#123c7b !important;
    font-weight:900;
}

/* TABLE */
table{
    width:100%;
    border-collapse:collapse;
    font-size:20px;
}
td, th{
    border:1px solid #ccc;
    padding:2px 4px;  /* <-- Minimum padding */
}

/* BUTTONS */
#printbtn,#closebtn{
    font-weight:bold;
    padding:6px 16px;
}

/* PRINT FORCE */
@media print{
    body{
        -webkit-print-color-adjust:exact !important;
        print-color-adjust:exact !important;
    }
    *{
        -webkit-print-color-adjust:exact !important;
        print-color-adjust:exact !important;
    }
    #printbtn,#closebtn{display:none;}
}
</style>
</head>

<body>
<div class="container">

<?php
require 'connection.php';
$dated=$_GET['from'];

/* ================= STOCK VALUE (SAME LOGIC AS ORIGINAL) ================= */

$Tstockvalue = 0;

$qry = "
SELECT stockledger.itemid
FROM stockledger
JOIN itemreg ON stockledger.itemid = itemreg.itemid
WHERE stockledger.dated <= '$dated'
GROUP BY stockledger.itemid
HAVING (SUM(stockin) - SUM(stockout)) > 0
ORDER BY stockledger.itemid
";

$run_qry = mysqli_query($connect, $qry);

while ($row = mysqli_fetch_assoc($run_qry)) {

    $itemid = $row['itemid'];

    $stkin = 0;
    $stkout = 0;
    $currstk = 0;
    $curravgrate = 0;
    $currstockvalue = 0;

    $qry2 = "
    SELECT stockin, ratein, stockout
    FROM stockledger
    WHERE itemid='$itemid'
    AND dated <= '$dated'
    ORDER BY dated, trid ASC
    ";

    $run_qry2 = mysqli_query($connect, $qry2);

    while ($row2 = mysqli_fetch_assoc($run_qry2)) {

        $stkin  = round($row2['stockin'], 2);
        $stkout = round($row2['stockout'], 2);

        // quantity movement
        $currstk = round(($currstk + $stkin - $stkout), 2);

        // stock in value
        $currstockvalue += ($stkin * round($row2['ratein'], 2));

        // average rate & stock out valuation
        if ($currstockvalue > 0 && $currstk > 0) {
            $currstockvalue -= ($stkout * round($curravgrate, 2));
            $curravgrate = $currstockvalue / $currstk;
        }

        // reset if stock becomes zero
        if ($currstk == 0) {
            $curravgrate = 0;
            $currstockvalue = 0;
        }
    }

    $Tstockvalue += $currstockvalue;
}


/* ===== LEDGERS ===== */
function led($gid,$d,$c,$s='>0'){
    $t=0;
    $q="SELECT SUM(debit)-SUM(credit) b
        FROM ledger JOIN accreg USING(accid)
        WHERE groupid='$gid' AND ledger.dated<='$d'
        GROUP BY accid";
    $r=mysqli_query($c,$q);
    while($x=mysqli_fetch_assoc($r))$t+=$x['b'];
    return $t;
}

$cash=led(3,$dated,$connect);
$bank=led(9,$dated,$connect);
$recv=led(1,$dated,$connect);
$other=led(15,$dated,$connect);
$pay=abs(led(12,$dated,$connect,'<0'));

$total_assets=$cash+$bank+$recv+$other+$Tstockvalue;
$capital=$total_assets-$pay;
?>

<button id="printbtn" class="btn btn-primary btn-sm">Print</button>
<button id="closebtn" class="btn btn-warning btn-sm">Close</button>

<h2 class="balance-title">BALANCE SHEET</h2>
<h4 class="balance-title">As on <?php echo date('d-m-Y',strtotime($dated)); ?></h4>

<table>

<tr class="assets-head"><td colspan="2">ASSETS</td></tr>
<tr class="asset"><td><h3>01. Cash In Hand</h3></td><td class="amount"><?=number_format($cash,2)?></td></tr>
<tr class="asset"><td><h3>02. Bank Balance</h3></td><td class="amount"><?=number_format($bank,2)?></td></tr>
<tr class="asset"><td><h3>03. Accounts Receivable</h3></td><td class="amount"><?=number_format($recv,2)?></td></tr>
<tr class="asset"><td><h3>04. Other Receivable</h3></td><td class="amount"><?=number_format($other,2)?></td></tr>
<tr class="asset"><td><h3>05. Stock Value</td></h3><td class="amount"><?=number_format($Tstockvalue,2)?></td></tr>
<tr class="total-assets"><td>Total Assets</td><td class="amount"><?=number_format($total_assets,2)?></td></tr>

<tr class="liability-head"><td colspan="2">LIABILITIES</td></tr>
<tr class="liability"><td><h3>06. Accounts Payable</h3></td><td class="amount"><?=number_format($pay,2)?></td></tr>

<tr class="capital-head"><td colspan="2">CAPITAL</td></tr>
<tr><td><h3>Owner’s Equity / Net Worth</h3></td><td class="amount"><?=number_format($capital,2)?></td></tr>

</table>
</div>




<style>
/* VIP Theme - Bank Table */
#lablrpt-bank {
    font-weight: 700;
    color: #2e7d32; /* Deep green header */
    margin-bottom: 10px;
}

.vip-bank-table {
    width: 100%;
    border-collapse: collapse;
    background: #e8f5e9; /* Light green background */
    font-family: "Segoe UI", Arial, sans-serif;
    font-size: 13px;
}

.vip-bank-table th, .vip-bank-table td {
    border: 1px solid #388e3c; /* Green border */
    padding: 4px 6px; /* Compact padding */
}

.vip-bank-table th {
    background: linear-gradient(90deg, #388e3c, #a5d6a7); /* Gradient header */
    color: white;
    font-weight: 700;
    text-align: center;
}

.vip-bank-table td {
    background: #c8e6c9; /* Light green rows */
    color: #1b5e20; /* Dark green text */
}

.vip-bank-table tr:nth-child(even) td {
    background: #f1f8e9; /* Alternate row color */
}

.vip-bank-table tr:hover td {
    background: #a5d6a7; /* Hover effect */
}

.vip-bank-total {
    font-weight: 900;
    background: #81c784;
    color: #1b5e20;
    font-size: 14px;
}

.vip-bank-table td.amount {
    text-align: right;
    font-weight: bold;
}
</style>

<div class="col-lg-5 col-md-5 col-sm-5">
   <h4 id="lablrpt-bank">02. Bank Balance</h4> 

   <table class="vip-bank-table">      
        <tr>
            <th colspan="4">Account Name</th>
            <th> Balance</th>
        </tr>

        <?php
        $totalbal = 0;
        $qry = "SELECT * FROM accreg WHERE activityacc=0 AND groupid = 9 ORDER BY accname ASC";
        $run_qry = mysqli_query($connect, $qry);
        while ($row = mysqli_fetch_array($run_qry)) {
            $runingaccid = $row['accid'];

            // Closing balance
            $qryopbal = "SELECT sum(debit)-sum(credit) as closbal FROM ledger WHERE accid = '$runingaccid'";
            $run_qryopbal = mysqli_query($connect, $qryopbal);
            $rowopbal = mysqli_fetch_array($run_qryopbal); 
            $closbal = $rowopbal['closbal'];
            $totalbal += $closbal;

            if($closbal<>0){
        ?>

        <tr>
            <td class="amount" colspan="4"><?php echo $row['accname']; ?></td>
            <td class="amount"><?php echo number_format($closbal,2); ?></td>
        </tr>

        <?php
            $closbal=0;
            }
        }
        ?>
    
        <tr class="vip-bank-total">
            <td colspan="4">Total</td>
            <td class="amount"><?php echo number_format($totalbal,2); ?></td>
        </tr>
    </table>
</div>




<br>
<br>

<hr style="border: 0; border-bottom: 5px solid #000; margin: 10px 0;">

<br>
<br>










<style>
/* VIP Theme - Receivable Table */
#lablrpt-receivable {
    font-weight: 700;
    color: #0277bd; /* Deep blue header */
    margin-bottom: 10px;
}

.vip-receivable-table {
    width: 100%;
    border-collapse: collapse;
    background: #e1f5fe; /* Light blue background */
    font-family: "Segoe UI", Arial, sans-serif;
    font-size: 13px;
}

.vip-receivable-table th, .vip-receivable-table td {
    border: 1px solid #0288d1; /* Blue border */
    padding: 4px 6px; /* Compact padding */
}

.vip-receivable-table th {
    background: linear-gradient(90deg, #0288d1, #81d4fa); /* Gradient header */
    color: white;
    font-weight: 700;
    text-align: center;
}

.vip-receivable-table td {
    background: #b3e5fc; /* Light blue rows */
    color: #01579b; /* Dark blue text */
}

.vip-receivable-table tr:nth-child(even) td {
    background: #e1f5fe; /* Alternate row color */
}

.vip-receivable-table tr:hover td {
    background: #81d4fa; /* Hover effect */
}

.vip-receivable-total {
    font-weight: 900;
    background: #4fc3f7;
    color: #01579b;
    font-size: 14px;
}

.vip-receivable-table td.amount {
    text-align: right;
    font-weight: bold;
}
</style>

<div class="col-lg-5 col-md-5 col-sm-5">
   <h4 id="lablrpt-receivable">03. Receivable Balance / لینا ہے</h4> 

   <table class="vip-receivable-table">      
        <tr>
            <th colspan="4">Account Name</th>
            <th>Balance</th>
        </tr>

        <?php
        $totalbal = 0;
        $qry = "SELECT 
            sum(debit) - sum(credit) as Receiveable_Balance, ledger.accid, accname, phone
            FROM ledger 
            JOIN accreg ON ledger.accid=accreg.accid
            JOIN groupreg ON accreg.groupid=groupreg.groupid
            WHERE groupreg.groupid=1
            AND ledger.dated <= '$dated'
            GROUP BY ledger.accid 
            HAVING sum(debit) - sum(credit) > 0";

        $run_qry = mysqli_query($connect, $qry);
        while ($row=mysqli_fetch_array($run_qry)) {
            $runingaccid = $row['accid'];

            // Closing balance
            $qryopbal = "SELECT sum(debit)-sum(credit) as closbal FROM ledger WHERE accid = '$runingaccid' AND ledger.dated <= '$dated'";
            $run_qryopbal = mysqli_query($connect, $qryopbal);
            $rowopbal = mysqli_fetch_array($run_qryopbal); 
            $closbal = $rowopbal['closbal'];
            $totalbal += $closbal;

            if($closbal<>0){
        ?>

        <tr>
            <td class="amount" colspan="4"><?php echo $row['accname'].'  #'.$row['phone']; ?></td>
            <td class="amount"><?php echo number_format($closbal,2); ?></td>
        </tr>

        <?php
            $closbal=0;
            }
        }
        ?>
    
        <tr class="vip-receivable-total">
            <td colspan="4">Total</td>
            <td class="amount"><?php echo number_format($totalbal,2); ?></td>
        </tr>
    </table>
</div>



<br>
<br>

<hr style="border: 0; border-bottom: 5px solid #000; margin: 10px 0;">

<br>
<br>





<style>
/* VIP Theme - Receivable Table */
#lablrpt-receivable {
    font-weight: 700;
    color: #0277bd; /* Deep blue header */
    margin-bottom: 10px;
}

.vip-receivable-table {
    width: 100%;
    border-collapse: collapse;
    background: #e1f5fe; /* Light blue background */
    font-family: "Segoe UI", Arial, sans-serif;
    font-size: 13px;
}

.vip-receivable-table th, .vip-receivable-table td {
    border: 1px solid #0288d1; /* Blue border */
    padding: 4px 6px; /* Compact padding */
}

.vip-receivable-table th {
    background: linear-gradient(90deg, #0288d1, #81d4fa); /* Gradient header */
    color: white;
    font-weight: 700;
    text-align: center;
}

.vip-receivable-table td {
    background: #b3e5fc; /* Light blue rows */
    color: #01579b; /* Dark blue text */
}

.vip-receivable-table tr:nth-child(even) td {
    background: #e1f5fe; /* Alternate row color */
}

.vip-receivable-table tr:hover td {
    background: #81d4fa; /* Hover effect */
}

.vip-receivable-total {
    font-weight: 900;
    background: #4fc3f7;
    color: #01579b;
    font-size: 14px;
}

.vip-receivable-table td.amount {
    text-align: right;
    font-weight: bold;
}
</style>

<div class="col-lg-5 col-md-5 col-sm-5">
   <h4 id="lablrpt-receivable">04. Other Receivable Balance / لینا ہے</h4> 

   <table class="vip-receivable-table">      
        <tr>
            <th colspan="4">Account Name</th>
            <th>Balance</th>
        </tr>

        <?php
        $totalbal = 0;
        $qry = "SELECT 
            sum(debit) - sum(credit) as Receiveable_Balance, ledger.accid, accname, phone
            FROM ledger 
            JOIN accreg ON ledger.accid=accreg.accid
            JOIN groupreg ON accreg.groupid=groupreg.groupid
            WHERE groupreg.groupid=15
            AND ledger.dated <= '$dated'
            GROUP BY ledger.accid 
            HAVING sum(debit) - sum(credit) > 0";

        $run_qry = mysqli_query($connect, $qry);
        while ($row=mysqli_fetch_array($run_qry)) {
            $runingaccid = $row['accid'];

            // Closing balance
            $qryopbal = "SELECT sum(debit)-sum(credit) as closbal FROM ledger WHERE accid = '$runingaccid' AND ledger.dated <= '$dated'";
            $run_qryopbal = mysqli_query($connect, $qryopbal);
            $rowopbal = mysqli_fetch_array($run_qryopbal); 
            $closbal = $rowopbal['closbal'];
            $totalbal += $closbal;

            if($closbal<>0){
        ?>

        <tr>
            <td class="amount" colspan="4"><?php echo $row['accname'].'  #'.$row['phone']; ?></td>
            <td class="amount"><?php echo number_format($closbal,2); ?></td>
        </tr>

        <?php
            $closbal=0;
            }
        }
        ?>
    
        <tr class="vip-receivable-total">
            <td colspan="4">Total</td>
            <td class="amount"><?php echo number_format($totalbal,2); ?></td>
        </tr>
    </table>
</div>



<br>
<br>

<hr style="border: 0; border-bottom: 5px solid #000; margin: 10px 0;">

<br>
<br>




<style>
/* VIP Theme - Stock Table */
#lablrpt-stock {
    font-weight: 700;
    color: #f57f17; /* Deep amber header */
    margin-bottom: 10px;
}

.vip-stock-table {
    width: 100%;
    border-collapse: collapse;
    background: #fff8e1; /* Light amber background */
    font-family: "Segoe UI", Arial, sans-serif;
    font-size: 13px;
}

.vip-stock-table th, .vip-stock-table td {
    border: 1px solid #ffa000; /* Amber border */
    padding: 4px 6px; /* Compact padding */
}

.vip-stock-table th {
    background: linear-gradient(90deg, #ffa000, #ffecb3); /* Gradient header */
    color: white;
    font-weight: 700;
    text-align: center;
}

.vip-stock-table td {
    background: #fff3e0; /* Light amber rows */
    color: #e65100; /* Dark amber text */
}

.vip-stock-table tr:nth-child(even) td {
    background: #fff8e1; /* Alternate row color */
}

.vip-stock-table tr:hover td {
    background: #ffe082; /* Hover effect */
}

.vip-stock-total {
    font-weight: 900;
    background: #ffca28;
    color: #e65100;
    font-size: 14px;
}

.vip-stock-table td.amount {
    text-align: right;
    font-weight: bold;
}
</style>

<div class="col-lg-5 col-md-5 col-sm-5">
   <h4 id="lablrpt-stock">05. Stock Value</h4> 

   <table class="vip-stock-table">      
        <tr>
            <th colspan="4">Product Name</th>
            <th>Stock</th>
            <th>Value</th>
        </tr>

        <?php
        $Tstockvalue = 0;
        $Tstockqty = 0;

        $qry = "SELECT stockledger.itemid, itemname
                FROM stockledger
                JOIN itemreg ON stockledger.itemid = itemreg.itemid
                WHERE stockledger.dated<='$dated'
                GROUP BY stockledger.itemid, itemname
                HAVING (SUM(stockin) - SUM(stockout)) > 0
                ORDER BY stockledger.itemid";
        $run_qry = mysqli_query($connect, $qry);

        while($row = mysqli_fetch_array($run_qry)){       
            $itemid = $row['itemid'];
            $currstk = 0;
            $currstockvalue = 0;
            $curravgrate = 0;

            $qry2 = "SELECT stockin, ratein, stockout 
                     FROM stockledger  
                     WHERE itemid='$itemid' AND dated<='$dated' 
                     ORDER BY dated,trid ASC";
            $run_qry2 = mysqli_query($connect, $qry2);

            while($row2 = mysqli_fetch_array($run_qry2)){       
                $stkin = round($row2['stockin'],2);
                $stkout = round($row2['stockout'],2);

                $currstk = round(($currstk+$stkin-$stkout),4);
                $currstockvalue += ($stkin * round($row2['ratein'],2));

                if($currstockvalue>0 and $currstk>0){
                    $currstockvalue -= ($stkout * round($curravgrate,2));
                    $curravgrate = $currstockvalue / $currstk;
                }

                if($currstk==0){
                    $curravgrate = 0;
                    $currstockvalue = 0;
                }
            }
        ?>

        <tr>
            <td class="amount" colspan="4"><?php echo $row['itemname']; ?></td>
            <td class="amount"><?php echo $currstk; ?></td>
            <td class="amount"><?php echo number_format($currstockvalue,2); ?></td>
        </tr>

        <?php
            $Tstockvalue += $currstockvalue;
            $Tstockqty += $currstk;
        }
        ?>

        <tr class="vip-stock-total">
            <td colspan="4">Total</td>
            <td><?php echo $Tstockqty; ?></td>
            <td class="amount"><?php echo number_format($Tstockvalue,2); ?></td>
        </tr>

    </table>
</div>



<br>
<br>

<hr style="border: 0; border-bottom: 5px solid #000; margin: 10px 0;">

<br>
<br>





<style>
/* VIP Table Theme */
#lablrpt {
    font-weight: 700;
    color: #6a1b9a; /* Deep purple header */
    margin-bottom: 10px;
}

.vip-table {
    width: 100%;
    border-collapse: collapse;
    background: #fdf6ff; /* Light purple background */
    font-family: "Segoe UI", Arial, sans-serif;
    font-size: 14px;
}

.vip-table th, .vip-table td {
    border: 1px solid #9c27b0; /* Purple border */
    padding: 4px 6px; /* Compact padding */
}

.vip-table th {
    background: linear-gradient(90deg, #9c27b0, #e1bee7); /* Gradient header */
    color: white;
    font-weight: 700;
    text-align: center;
}

.vip-table td {
    background: #f3e5f5; /* Light purple rows */
    color: #4a148c; /* Dark purple text */
}

.vip-table tr:nth-child(even) td {
    background: #ede7f6; /* Alternate row color */
}

.vip-table tr:hover td {
    background: #d1c4e9; /* Hover effect */
}

.vip-total {
    font-weight: 900;
    background: #ce93d8;
    color: #4a148c;
    font-size: 15px;
}

.vip-table td.amount {
    text-align: right;
    font-weight: bold;
}
/* PRINT FORCE */
@media print{
    body{
        -webkit-print-color-adjust:exact !important;
        print-color-adjust:exact !important;
    }
    *{
        -webkit-print-color-adjust:exact !important;
        print-color-adjust:exact !important;
    }
    #printbtn,#closebtn{display:none;}
}
</style>

<div class="col-lg-5 col-md-5 col-sm-5">
   <h4 id="lablrpt">06. Payable Balance / دینا ہے</h4> 

   <table class="vip-table">      
        <tr>
            <th colspan="4">Account Name</th>
            <th>Balance</th>
        </tr>

        <?php
        $crtotal = 0;
        $credit = 0;
        $debit = 0;
        $oppbal = 0;
        $oppbaltotal = 0;
        $closbal = 0;
        $qty = 0;
        $runingaccid ='';
        $drtotal = 0;
        $totalbal = 0;

        $qry = "SELECT 
            sum(debit) - sum(credit) as Payable_Balance, ledger.accid, accname
            FROM ledger 
            JOIN accreg ON ledger.accid=accreg.accid
            JOIN groupreg ON accreg.groupid=groupreg.groupid
            WHERE accreg.groupid=12
            and ledger.dated <= '$dated'
            GROUP BY ledger.accid 
            HAVING sum(debit) - sum(credit) < 0";

        $run_qry = mysqli_query($connect, $qry);
        while ($row=mysqli_fetch_array($run_qry)) {
            $runingaccid=$row['accid'];

            // Closing balance
            $qryopbal = "SELECT sum(debit)-sum(credit) as closbal FROM ledger WHERE accid = '$runingaccid' AND ledger.dated <= '$dated'";
            $run_qryopbal = mysqli_query($connect, $qryopbal);
            $rowopbal=mysqli_fetch_array($run_qryopbal); 
            $closbal=$rowopbal['closbal'];
            $totalbal += $closbal;

            if($closbal<>0){
        ?>

        <tr>
            <td class="amount" colspan="4"><?php echo $row['accname']; ?></td>
            <td class="amount"><?php echo number_format($closbal,2); ?></td>
        </tr>

        <?php
            $closbal=0;
            }
        }
        ?>
    
        <tr class="vip-total">
            <td colspan="4">Total</td>
            <td class="amount"><?php echo number_format($totalbal,2); ?></td>
        </tr>
    </table>
</div>






<br>
<br>

<hr style="border: 0; border-bottom: 5px solid #000; margin: 10px 0;">

<br>
<br>

<div class="col-lg-12">
    <h4 style="margin-bottom:20px; color:#2c3e50;">Today Summary</h4>

    <style>
        .summary-table {
            width: 100%;
            border-collapse: collapse;
            font-family: "Segoe UI", Arial, sans-serif;
            font-size: 16px;
        }

        .summary-table th, .summary-table td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        .summary-table th {
            background-color: #2980b9;
            color: #fff;
            text-align: left;
        }

        .summary-table tr.table-primary {
            background-color: #ecf0f1;
            font-weight: bold;
        }

        .summary-table tr:hover {
            background-color: #f1f1f1;
        }

        .summary-table td.text-right {
            text-align: right;
        }

        .summary-detail {
            padding-left: 25px;
            font-style: italic;
        }
    </style>

    <table class="summary-table">
        <tr>
            <th>Account</th>
            <th>Type</th>
            <th>Detail</th>
            <th class="text-right">Amount</th>
        </tr>

<?php
$qry = "
SELECT 
    l.entrytype,
    l.description,
    l.debit,
    l.credit,
    l.qty,
    l.rate,
    l.itemid,
    a.accname,
    i.itemname
FROM ledger l
JOIN accreg a ON l.accid = a.accid
JOIN groupreg g ON a.groupid = g.groupid
LEFT JOIN itemreg i ON l.itemid = i.itemid
WHERE (g.groupid = 1 OR g.groupid = 12)
AND DATE(l.dated) = '$dated'
AND (
        (l.entrytype = 'Purchase' AND l.itemid > 0)
     OR (l.entrytype = 'Sales' AND l.itemid > 0)
     OR (l.entrytype = 'BRV')
     OR (l.entrytype = 'BPV')
    )
ORDER BY 
    
    FIELD(l.entrytype,'Purchase','Sales','BRV','BPV'),
    l.dated
";

$run = mysqli_query($connect, $qry);

$lastAcc = '';
$entries = []; // temporary array to store account entries

while($row = mysqli_fetch_assoc($run)) {
    $acc = $row['accname'];

    // Prepare amount & detail
    $amount = 0;
    $detail = '';

    if($row['entrytype'] == 'Sales' || $row['entrytype'] == 'Purchase') {
        $amount = $row['qty'] * $row['rate'];
        $detail = $row['itemname'] . " ({$row['qty']} @ {$row['rate']})";
    } elseif($row['entrytype'] == 'BRV') {
        $amount = $row['credit'];
        $detail = $row['description'];
    } elseif($row['entrytype'] == 'BPV') {
        $amount = $row['debit'];
        $detail = $row['description'];
    }

    // Store in entries array by account
    $entries[$acc][] = [
        'entrytype' => $row['entrytype'],
        'detail' => $detail,
        'amount' => $amount
    ];
}

// Loop through each account and display
foreach($entries as $accName => $accEntries) {
    // Account header
    echo "<tr class='table-primary'>
            <td><b>{$accName}</b></td>
            <td colspan='3'></td>
          </tr>";

    // All entries under this account
    foreach($accEntries as $entry) {
        echo "<tr>
              
                <td>{$entry['entrytype']}</td>
                <td colspan='2'>{$entry['detail']}</td>
                <td class='text-right'>" . number_format($entry['amount'],2) . "</td>
              </tr>";
    }
}
?>

    </table>
</div>






<script>
printbtn.onclick=()=>window.print();
closebtn.onclick=()=>window.close();
</script>
</body>
</html>
