<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>DIGITAL ACCOUNTS MANAGEMENT</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="author" content="KASHIF ALI">

    <!-- CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/jquery-ui.css">
    <link rel="stylesheet" href="css/bootsrap_my.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

    <style>
        body { background-color: #f4f7fa; }

        .table th, .table td {
            text-align: center;
            vertical-align: middle;
        }

        .table thead {
            background-color: #343a40;
            color: #fff;
        }

        .account-name {
            font-weight: bold;
            text-align: left;
        }

        .account-name img {
            height: 22px;
            margin-right: 6px;
            vertical-align: middle;
            border-radius: 4px;
        }

        .account-name small {
            font-weight: normal;
            color: #555;
        }

        .grand-total-row {
            font-weight: bold;
            background-color: #f1f1f1;
        }

        #printbtn { margin-right: 5px; }
    </style>
</head>

<body>

<div class="container mt-3">

<?php
require 'connection.php';

$accid = $_GET['accid'];
$from  = $_GET['from'];
$to    = $_GET['to'];

/* Group Name */
$qry = "SELECT groupname FROM groupreg WHERE groupid='$accid'";
$run = mysqli_query($connect,$qry);
$row = mysqli_fetch_assoc($run);
$groupname = $row['groupname'];
?>

<h5>Group Name: <?php echo $groupname; ?></h5>
<h5>From <?php echo date('d-m-Y',strtotime($from)); ?> To <?php echo date('d-m-Y',strtotime($to)); ?></h5>

<div class="table-responsive">

<button class="btn btn-primary btn-sm" id="printbtn"><i class="fas fa-print"></i> Print</button>
<button class="btn btn-warning btn-sm" id="closebtn"><i class="fas fa-times"></i></button>

<table class="table table-striped table-bordered mt-2">
<thead>
<tr>
    <th>SR#</th>
     
    <th colspan='2'>Account Name</th>
    <th>Opening</th>
    <th>Debit</th>
    <th>Credit</th>
    <th>Balance</th>
</tr>
</thead>

<tbody>
<?php
$srno = 1;
$grandOpening = $grandDebit = $grandCredit = $grandBalance = 0;

$qry = "SELECT * FROM accreg WHERE groupid='$accid' ORDER BY accid ASC";
$run = mysqli_query($connect,$qry);

while($row = mysqli_fetch_assoc($run)){

    $aid   = $row['accid'];
    $phone = $row['phone'];
    $accname = strtoupper($row['accname']);

    /* Bank Logo Detection */
    $bankLogo = "";
    if (strpos($accname,'MCB') !== false) $bankLogo = "img_mcb.png";
    
    
    elseif (strpos($accname,'HABIB METRO') !== false) $bankLogo = "img_habibmet.png";
    
     elseif (strpos($accname,'MBL') !== false) $bankLogo = "img_mbl.png";
    elseif (strpos($accname,'JAZZCASH') !== false) $bankLogo = "img_jazzcash.png";
      elseif (strpos($accname,'FAYSAL BANK') !== false) $bankLogo = "img_faysal.jpg";
    elseif (strpos($accname,'UBL') !== false) $bankLogo = "img_ubl.png";
    
        elseif (strpos($accname,'ISLAMI BANK') !== false) $bankLogo = "img_islamic.jpg";
    
 
    elseif (strpos($accname,'HBL') !== false) $bankLogo = "img_hbl.png";
    elseif (strpos($accname,'AL HABIB') !== false || strpos($accname,'BANK AL HABIB') !== false) $bankLogo = "img_alhabib.jpg";
    elseif (strpos($accname,'AL-FALAH') !== false) $bankLogo = "img_alfalah.png";
      elseif (strpos($accname,'AL FALAH') !== false) $bankLogo = "img_alfalah.png";
    elseif (strpos($accname,'ABL') !== false || strpos($accname,'ALLIED') !== false) $bankLogo = "img_abl.png";

    /* Opening */
    $q = "SELECT SUM(debit)-SUM(credit) op FROM ledger WHERE accid='$aid' AND dated<'$from'";
    $op = mysqli_fetch_assoc(mysqli_query($connect,$q))['op'] ?? 0;

    /* Period Debit Credit */
    $q = "SELECT SUM(debit) d,SUM(credit) c FROM ledger WHERE accid='$aid' AND dated BETWEEN '$from' AND '$to'";
    $r = mysqli_fetch_assoc(mysqli_query($connect,$q));
    $debit  = $r['d'] ?? 0;
    $credit = $r['c'] ?? 0;

    /* Closing */
    $q = "SELECT SUM(debit)-SUM(credit) cb FROM ledger WHERE accid='$aid' AND dated<='$to'";
    $cb = mysqli_fetch_assoc(mysqli_query($connect,$q))['cb'] ?? 0;

    $grandOpening += $op;
    $grandDebit   += $debit;
    $grandCredit  += $credit;
    $grandBalance += $cb;

echo "<tr>";
echo "<td>{$srno}</td>";

/* BANK LOGO COLUMN */


/* ACCOUNT NAME COLUMN */
echo "<td class='account-name'>";
echo "{$row['accname']}<br><small>{$phone}</small>";
echo "</td>";
echo "<td style='text-align:center;'>";
if ($bankLogo != "") {
    echo "<img src='images/$bankLogo' style='height:70px; width:70px; object-fit:contain;'>";
}
echo "</td>";
echo "<td class='account-name'>{$op}</td>";
echo "<td class='account-name'>{$debit}</td>";
echo "<td class='account-name'>{$credit}</td>";
echo "<td class='account-name'>{$cb}</td>";
echo "</tr>";

    $srno++;
}
?>
</tbody>

<tfoot>
<tr class="grand-total-row">
    <td colspan="3" class="text-right">Grand Total</td>
    <td><?php echo $grandOpening; ?></td>
    <td><?php echo $grandDebit; ?></td>
    <td><?php echo $grandCredit; ?></td>
    <td><?php echo $grandBalance; ?></td>
</tr>
</tfoot>

</table>
</div>
</div>

<!-- JS -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script>
$('#printbtn').click(function(){
    $('#printbtn,#closebtn').hide();
    window.print();
});
$('#closebtn').click(function(){
    window.close();
});
</script>

</body>
</html>
