<?php
session_start();
require 'connection.php';

$today = isset($_POST['dated']) ? $_POST['dated'] : date('Y-m-d');
$paymentMode = isset($_POST['payment_mode']) ? $_POST['payment_mode'] : '';
?>

<style>
/* Glow table style */
.glow-table {
    border-collapse: collapse;
    width: 100%;
    margin-top: 20px;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: #222;
}
.glow-table th, .glow-table td {
    padding: 10px;
    text-align: left;
    font-weight: bold;
    border: 1px solid #444;
    transition: all 0.3s ease;
}
.glow-table th {
    background: #f0f0f0;
    color: #222;
    text-shadow: 0 0 2px #00bfff;
    border-bottom: 2px solid #00bfff;
}
.glow-table tbody tr:hover {
    background: rgba(0, 191, 255, 0.1);
    box-shadow: 0 0 6px #00bfff;
}
.glow-table tbody tr:nth-child(even) {
    background-color: rgba(0, 0, 0, 0.02);
}
.glow-table tbody tr:nth-child(odd) {
    background-color: rgba(0, 0, 0, 0.0);
}
</style>

<?php
$qry = "SELECT bp.vno,bp.verified, bp.dated, b.accname AS bank, a.accname AS paid_to,
        bp.payment_mode, bp.description, bp.amount, bp.cheque_or_refno
        FROM bp_voucher bp
        LEFT JOIN accreg b ON bp.bankid = b.accid
        LEFT JOIN accreg a ON bp.accid = a.accid
        WHERE DATE(bp.dated) = '$today'";


if(!empty($paymentMode)){
    $qry .= " AND bp.payment_mode = '".mysqli_real_escape_string($connect,$paymentMode)."'";
}

$qry .= " ORDER BY bp.vno DESC";

$result = mysqli_query($connect, $qry);
$totalAmount = 0;
?>
<?php
if(isset($_SESSION['userId']) && $_SESSION['userId'] == 52){
?>

<style>
@media print {
    #showUpdateBox,
    #updateArea {
        display: none !important;
        visibility: hidden !important;
    }
}
</style>

<!-- Checkbox -->
<label>
    <input type="checkbox" id="showUpdateBox">Box
</label>

<!-- Hidden Box -->
<div id="updateArea" style="display:none; margin-top:10px;">
    <input type='text' id='edtvno' placeholder="Enter Vno">
    <button class='btn btn-success btn-xs' id='btnupdate'>Update</button>
</div>

<script>
    // Show / Hide on Checkbox Click
    $('#showUpdateBox').change(function(){
        if($(this).is(':checked')){
            $('#updateArea').show();
        } else {
            $('#updateArea').hide();
        }
    });

    // Button Click
    $('#btnupdate').click(function(){
        var bpvno = $('#edtvno').val();
        var accid = $('#accid').val();
         var description = $('#description').val();

        $.ajax({
            url: 'updt_bpv.php',
            method: 'POST',
            data: { bpvno: bpvno, accid: accid, description: description },
            success: function(data){
                alert(data);
            }
        });
    });
</script>

<?php
}
?>



  
  
  
  

<table class="glow-table">
    <thead>
        <tr>
            <th>V#</th>
            <th>Date</th>
            <th>Bank</th>
            <th>Paid To</th>
            <th>Payment Mode</th>
            <th>Description</th>
            <th>Amount</th>
            <th>Cheque / Ref#</th>
            <?php
          
if(isset($_SESSION['userId']) && $_SESSION['userId'] == 52){
?>
          <th>Status</th>
            
            <?php
            }
            ?>
        </tr>
    </thead>
    <tbody>
<?php
if(!$result){
    echo "<tr><td colspan='8' class='text-center text-danger fw-bold'>Query Error: ".mysqli_error($connect)."</td></tr>";
} elseif(mysqli_num_rows($result) > 0){
  while($row = mysqli_fetch_assoc($result)){

    $totalAmount += floatval($row['amount']);

    // Row color condition
    $rowStyle = "";
    if (trim(strtoupper($row['paid_to'])) == "SUSPECTED ENTRIES") {
        $rowStyle = "style='background:#8B0000; color:white; font-weight:bold;'";
    }
?>

<tr <?php echo $rowStyle; ?>>
    <td><?php echo $row['vno']; ?></td>

    <td><?php echo date('d-m-y', strtotime($row['dated'])); ?></td>

    <td><?php echo $row['bank']; ?></td>
    <td><?php echo $row['paid_to']; ?></td>
    <td><?php echo $row['payment_mode']; ?></td>
    <td><?php echo $row['description']; ?></td>
    <td><?php echo $row['amount']; ?></td>
    <td><?php echo $row['cheque_or_refno']; ?></td>

    <?php if(isset($_SESSION['userId']) && $_SESSION['userId'] == 52){ ?>
        <td>
            <?php if($row['verified'] == 1){ ?>
                <img src="verify.png" alt="Verified" style="width:50px;">
            <?php } else { ?>
               <button class='verifybtn' data-vno="<?php echo $row['vno']; ?>">Verify</button>

            <?php } ?>
        </td>
    <?php } ?>
</tr>


    <?php
}

    // Grand Total row
    echo "<tr style='font-weight:bold; background:#f0f0f0;'>
        <td colspan='6' class='text-end'>Grand Total:</td>
        <td>{$totalAmount}</td>
        <td></td>
    </tr>";
} else {
    echo "<tr><td colspan='8' class='text-center fw-bold'>No vouchers found</td></tr>";
}
?>
    </tbody>
</table>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
$(document).on("click", ".verifybtn", function () {

    var vno = $(this).data("vno");
    var button = $(this);

    $.ajax({
        url: "verify.php",
        type: "POST",
        data: { vno: vno },
        success: function (response) {

            if(response == "ok"){
                // Replace button with verified image
                button.replaceWith('<img src="verify.png" width="50">');
            } else {
                alert("Error verifying record!");
            }
        }
    });

});
</script>

