<?php
require 'connection.php';

$fromdate = isset($_GET['fromdate']) ? $_GET['fromdate'] : '';
$todate   = isset($_GET['todate']) ? $_GET['todate'] : '';
$grandTotal = 0;
?>
<!DOCTYPE html>
<html>
<head>
<title>Purchase History Report</title>

<style>
body{
    font-family:"Segoe UI", Tahoma, Arial, sans-serif;
    background:#f4f6f9;
    margin:20px;
    color:#222;
    font-size:15px;
}

/* Page Title */
h1{
    font-size:30px;
    font-weight:800;
    margin-bottom:25px;
}

/* Filter Box */
.form-box{
    background:#fff;
    padding:18px 22px;
    border-radius:12px;
    box-shadow:0 4px 14px rgba(0,0,0,0.1);
    display:inline-block;
    margin-bottom:35px;
    font-weight:600;
}

input[type="date"]{
    padding:8px 12px;
    border:1px solid #bbb;
    border-radius:6px;
    margin-right:10px;
    font-size:15px;
    font-weight:600;
}

button{
    padding:9px 22px;
    background:#3498db;
    color:#fff;
    border:none;
    border-radius:6px;
    cursor:pointer;
    font-size:15px;
    font-weight:700;
}

button:hover{
    background:#2980b9;
}

/* Vendor Card */
.vendor-card{
    background:#fff;
    border-radius:14px;
    box-shadow:0 8px 22px rgba(0,0,0,0.1);
    margin-bottom:40px;
    overflow:hidden;
}

/* Vendor Heading */
.vendor-title{
    padding:18px 22px;
    font-size:24px;
    font-weight:800;
    color:#1f2d3d;
    border-left:7px solid #3498db;
    background:#f9fbff;
}

/* Table */
.report-table{
    width:100%;
    border-collapse:collapse;
}

/* Table Header */
.report-table thead{
    background:#eef2f6;
}

.report-table th{
    padding:14px 16px;
    text-align:left;
    font-size:15px;
    font-weight:800;
    text-transform:uppercase;
    color:#333;
}

/* Table Cells */
.report-table td{
    padding:14px 16px;
    font-size:15px;
    font-weight:600;
    border-bottom:1px solid #eee;
}

.report-table tr:last-child td{
    border-bottom:none;
}

.report-table tbody tr:hover{
    background:#f4f8ff;
}

/* Numeric alignment */
.num{
    /*text-align:right;*/
    white-space:nowrap;
}

/* Amount highlight */
.amount{
    font-weight:800;
    font-size:16px;
    color:#1e9e47;
}

/* Grand Total Box */
.grand-total{
    margin-top:40px;
    background:#1f2d3d;
    color:#fff;
    padding:22px;
    border-radius:14px;
    font-size:26px;
    font-weight:900;
    text-align:right;
    box-shadow:0 8px 22px rgba(0,0,0,0.15);
}

/* Print */
@media print{
    body{
        background:#fff;
        margin:0;
    }
    .form-box{
        display:none;
    }
}
</style>
</head>

<body>

<h1>Purchase History Report</h1>

<div class="form-box">
<form method="get">
    From Date:
    <input type="date" name="fromdate" value="<?php echo $fromdate; ?>" required>

    To Date:
    <input type="date" name="todate" value="<?php echo $todate; ?>" required>

    <button type="submit">Show Report</button>
</form>
</div>

<?php
if($fromdate && $todate){

$sql = "SELECT
    p.prid,
    p.dated,
    p.accid,
    v.accname AS vendorname,
    i.itemname,
    s.stockin AS qty,
    s.ratein AS rate,
    (s.stockin * s.ratein) AS amount
FROM purchase p
JOIN stockledger s ON p.prid = s.vno
JOIN itemreg i ON s.itemid = i.itemid
JOIN accreg v ON p.accid = v.accid
WHERE 
    s.invoiceno = 'Purchase'
    AND p.dated BETWEEN '$fromdate' AND '$todate'
ORDER BY  p.dated, s.vno, s.trid";

$result = mysqli_query($connect,$sql);

$currentVendor = "";

while($row = mysqli_fetch_assoc($result)){

    $grandTotal += $row['amount'];

    if($currentVendor != $row['accid']){
        if($currentVendor != ""){
            echo "</tbody></table></div>";
        }

        $currentVendor = $row['accid'];

        echo "
        <div class='vendor-card'>
            <div class='vendor-title'>
                Vendor: ".$row['vendorname']."
            </div>

            <table class='report-table'>
            <thead>
                <tr>
                    <th>Date</th>
                    <th>VNO</th>
                    <th>Product Name</th>
                    <th class='num'>Qty</th>
                    <th class='num'>Rate</th>
                    <th class='num'>Amount</th>
                </tr>
            </thead>
            <tbody>
        ";
    }

    echo "
    <tr>
        <td>".$row['dated']."</td>
        <td>".$row['prid']."</td>
        <td>".$row['itemname']."</td>
        <td class='num'>".$row['qty']."</td>
        <td class='num'>".number_format($row['rate'])."</td>
        <td class='num amount'>".number_format($row['amount'])."</td>
    </tr>
    ";
}

if($currentVendor != ""){
    echo "</tbody></table></div>";
}

/* Grand Total */
echo "
<div class='grand-total'>
    GRAND TOTAL : ".number_format($grandTotal)."
</div>
";

}
?>

</body>
</html>
