<?php
session_start();
if(!isset($_SESSION['userId'])) {
    die('Unauthorized');
}

require 'connection.php';

// Get POST data
$dated = !empty($_POST['dated']) ? $_POST['dated'] : NULL;
$bankid = !empty($_POST['bankid']) ? intval($_POST['bankid']) : NULL;
$accid = !empty($_POST['accid']) ? intval($_POST['accid']) : NULL;
$payment_mode = !empty($_POST['payment_mode']) ? mysqli_real_escape_string($connect, $_POST['payment_mode']) : NULL;
$description = !empty($_POST['description']) ? mysqli_real_escape_string($connect, $_POST['description']) : '';
$amount = !empty($_POST['amount']) ? floatval($_POST['amount']) : NULL;
$cheque_or_refno = !empty($_POST['cheque_or_refno']) ? mysqli_real_escape_string($connect, $_POST['cheque_or_refno']) : '';
$userid = intval($_POST['userid'] ?? $_SESSION['userId']);
$remarks = !empty($_POST['remarks']) ? mysqli_real_escape_string($connect, $_POST['remarks']) : '';

// Generate next vno
$vno = 0;
$qry = "SELECT IFNULL(MAX(vno),0)+1 AS next_vno FROM bp_voucher";
$result = mysqli_query($connect, $qry);
if($row = mysqli_fetch_assoc($result)) {
    $vno = $row['next_vno'];
}

// Fetch bank and paid-to names
$bankName = '';
if($bankid !== NULL){
    $bankQry = "SELECT shortname FROM accreg WHERE accid = $bankid";
    $bankRes = mysqli_query($connect, $bankQry);
    if($bankRow = mysqli_fetch_assoc($bankRes)){
        $bankName = $bankRow['shortname'];
    }
}

$paidToName = '';
if($accid !== NULL){
    $accQry = "SELECT shortname FROM accreg WHERE accid = $accid";
    $accRes = mysqli_query($connect, $accQry);
    if($accRow = mysqli_fetch_assoc($accRes)){
        $paidToName = $accRow['shortname'];
    }
}

// Combined descriptions
$bankLedgerDesc = $paidToName . " / " . $description . " / " . $payment_mode;
$paidToLedgerDesc = $bankName . " / " . $description . " / " . $payment_mode;

// Insert into BPV table
$insertBPV = "INSERT INTO bp_voucher 
(dated, bankid, accid, vno, payment_mode, description, amount, cheque_or_refno, userid, remarks, created_at)
VALUES 
(" .
($dated ? "'$dated'" : "NULL") . ", " .
($bankid !== NULL ? $bankid : "NULL") . ", " .
($accid !== NULL ? $accid : "NULL") . ", " .
$vno . ", " .
($payment_mode ? "'$payment_mode'" : "NULL") . ", " .
"'$description', " .
($amount !== NULL ? $amount : "NULL") . ", " .
"'$cheque_or_refno', " .
$userid . ", " .
"'$remarks', NOW())";

if(mysqli_query($connect, $insertBPV)) {

    // Insert into ledger tables
    // Assuming ledger table has: dated, accid, vno, entrytype, debit, credit, description, userid, created_at
    
    // Bank ledger (credit)
    $bankLedger = "INSERT INTO ledger 
    (dated, accid, vno, entrytype, debit, credit, description, userid, dated2)
    VALUES 
    ('$dated', $bankid, $vno, 'BPV', 0, $amount, '$bankLedgerDesc', $userid, NOW())";

    mysqli_query($connect, $bankLedger);

    // Paid-to ledger (debit)
    $paidToLedger = "INSERT INTO ledger 
    (dated, accid, vno, entrytype, debit, credit, description, userid, dated2)
    VALUES 
    ('$dated', $accid, $vno, 'BPV', $amount, 0, '$paidToLedgerDesc', $userid, NOW())";

    mysqli_query($connect, $paidToLedger);

    echo "BPV saved successfully! Voucher No: $vno";

} else {
    echo "Error saving BPV: " . mysqli_error($connect);
}

?>
